import React, { Component } from 'react'
import PropTypes from 'prop-types'
import StadioSviluppoSelect from '../../Fields/StadioSviluppoSelect/StadioSviluppoSelect'
import MarcaturaSelect from '../../Fields/MarcaturaSelect/MarcaturaSelect'
import { Form, Text } from 'react-form'
import Loading from '../../../Loading/Loading'
import BlinkDot from '../../../Loading/BlinkDot'

export default class MonitoraggioSpecieRilieviForm extends Component {
  static propTypes = {
    formValues: PropTypes.object,
    submitting: PropTypes.bool,
    onSubmit: PropTypes.func.isRequired
  }

  constructor (props) {
    super(props)
  }

  render () {
    const { onSubmit, submitting, formValues } = this.props

    return (
      <Form defaultValues={formValues} onSubmit={onSubmit}>
        {formApi => {
          return (
            <form onSubmit={formApi.submitForm}>

	      <div className="form-row">
		<div className="col">
                <label>ID Habitat</label>
                <Text
                  id="idHabitat"
                  field="idHabitat"
                  className="form-control"
                />
		</div>
		<div className="col-sm-3">
		<label>Longitudine</label>
                <Text
                  id="coordinataX"
                  field="coordinataX"
                  className="form-control"
                />
		</div>
		<div className="col-sm-3">
		<label>Latitudine</label>
                <Text
                  id="coordinataY"
                  field="coordinataY"
                  className="form-control"
                />
		</div>
              </div>
	      <div className="form-row">
              <div className="col">
                <label>Esemplari M</label>
                <Text
                  id="esemplariM"
                  field="esemplariM"
                  type="number"
                  className="form-control"
                />
              </div>
              <div className="col">
                <label>Esemplari F</label>
                <Text
                  id="esemplariF"
                  field="esemplariF"
                  type="number"
                  className="form-control"
                />
              </div>
              <div className="col">
                <label>Esemplari MF</label>
                <Text
                  id="esemplariMF"
                  field="esemplariMF"
                  type="number"
                  className="form-control"
                />
              </div>
	      </div>

              <div className="form-group">
                <label>Stadio Sviluppo</label>
                <StadioSviluppoSelect
                  id="stadioSviluppo"
                  field="stadioSviluppo"
                  className="form-control"
                />
              </div>


	      <div className="form-row">
		  <div className="col">
	          <label>Tipo marcatura</label>
		  <MarcaturaSelect
                  id="tipoMarcatura"
                  field="tipoMarcatura"
                  className="form-control" />
		  
		  </div>
		  <div className="col">
               	 <label>Marcatura</label>
              	  <Text
              	    id="idMarcatura"
             	     field="idMarcatura"
             	     className="form-control"
            	    />
            	  </div>
               
	      </div>
	      <div className="form-row">
		  <div className="col">
	          <label>Tipo ricattura</label>
		  <MarcaturaSelect
                  id="tipoRicattura"
                  field="tipoRicattura"
                  className="form-control" />
		  
		  </div>
		  <div className="col">
               	 <label>Ricattura</label>
              	  <Text
              	    id="idRicattura"
             	     field="idRicattura"
             	     className="form-control"
            	    />
            	  </div>
               
	      </div>

              <div className="form-group">
                <label>Note</label>
                <Text
                  id="note"
                  field="note"
                  className="form-control"
                />
              </div>
              {submitting && (
                <React.Fragment>
                  <BlinkDot />
                  <BlinkDot />
                  <BlinkDot />
                </React.Fragment>
              )}
              <div>
                <button type="submit" className="btn btn-primary">
                  Salva
                </button>
              </div>
            </form>
          )
        }}
      </Form>
    )
  }
}
